#!/bin/bash

FILE=/tmp/nxupsvc.log
IN=/tmp/nxupui
OUT=/tmp/nxupsvc
    
echo "-----SonicWall NetExtender Auto Upgrade-----" >> $FILE
echo "Time:" $(date +"%F %H:%M:%S") >> $FILE

# Make sure only root can run our script
if [ "$(id -u)" -ne 0 ]; then
	echo "This script must be run as root."
	exit 1
fi

echo "Check nxupui" >> $FILE
i=0
while [ $i -le 30 ]; do
    if [ -f $IN ]; then
        break
    fi
    sleep 1
    ((i++))
done
if [ $i -eq 31 ]; then
    echo "Failed to check nxupui" >> $FILE
    echo "errorFailedToCheckNxupui" > $OUT
    exit 1
fi

echo "Read nxupui" >> $FILE
while read -r line || [[ -n $line ]]; do
    echo "$line" >> $FILE
    if [ "$line" == "openNxUpgradeUIDone" ]; then
        echo "NX upgrade UI is OK" >> $FILE
        break
    elif [ "$line" == "error"* ]; then
        echo "Found error: " $line >> $FILE
        exit 1
    fi
    sleep 1
done < $IN

echo "statusInitializing" > $OUT

echo "Copy nxuninstall.sh from /usr/local/netextender/ to /tmp/" >> $FILE
cp -f /usr/local/netextender/nxuninstall.sh /tmp/nxuninstall.sh
if [ $? -ne 0 ]; then
    echo "Failed to copy nxuninstall.sh" >> $FILE
    echo "errorFailedToCopyNxUninstall" > $OUT
    exit 1
fi
sleep 3

echo "statusPerforming" > $OUT

echo "Execute nxuninstall.sh" >> $FILE
/tmp/nxuninstall.sh -upgrade >> $FILE 2>&1
if [ $? -ne 0 ]; then
    echo "Failed to uninstall netextender" >> $FILE
    echo "errorFailedToUninstallNetextender" > $OUT
    exit 1
fi

echo "Uninstallation is done, delete /tmp/nxuninstall.sh" >> $FILE
rm -rf /tmp/nxuninstall.sh 
if [ $? -ne 0 ]; then
    echo "Failed to delete /tmp/nxuninstall.sh" >> $FILE
    echo "errorFailedToDeleteNxUninstall" > $OUT
    exit 1
fi

echo "Decompress the downloaded NetExtender file in /tmp" >> $FILE
cd /tmp && tar -xvf /tmp/NetExtender.tar.gz
if [ $? -ne 0 ]; then
    echo "Failed to decompress NetExtender.tar.gz" >> $FILE
    echo "errorFailedToDecompressNetextender" > $OUT
    exit 1
fi

echo "Execute install.sh" >> $FILE
cd /tmp/netextender && ./install.sh >> $FILE 2>&1
if [ $? -ne 0 ]; then
    echo "Failed to install netextender" >> $FILE
    echo "errorFailedToInstallNetExtender" > $OUT
    exit 1
fi

echo "Remove netextender folder" >> $FILE
cd /tmp && rm -rf netextender
if [ $? -ne 0 ]; then
    echo "Failed to remove /tmp/netextender folder" >> $FILE
    echo "errorFailedToRemoveNetExtender" > $OUT
    exit 1
fi

echo "Check NEService status" >> $FILE
i=0
while [ $i -le 30 ]
do
    systemctl is-active --quiet NEService
    if [ $? -eq 0 ]; then
        break
    fi
    sleep 3
    ((i++))
done

if [ $i -eq 30 ]; then
    echo "Failed to check NEService status" >> $FILE
    echo "errorFailedToCheckNEServiceStatus" > $OUT
    exit 1
fi

echo "statusSuccess" > $OUT

echo "Check nxupui" >> $FILE
i=0
while [ $i -le 30 ]
do
    if [ -f $IN ]; then
        VALUE=$(<$IN)
        echo $VALUE >> $FILE
        if [ "$VALUE" == "openNxUIDone" ]; then
            echo "NX UI is OK" >> $FILE
            break
        elif [ "$VALUE" == "error"* ]; then
            echo "Found error:" $VALUE >> $FILE
            exit 1
        fi
    else
        break
    fi
    sleep 3
    ((i++))
done

if [ $i -eq 31 ]; then
    echo "Failed to check nxupui" >> $FILE
    echo "ErrorFailedToCheckNxupui" > $OUT
    exit 1
fi

echo "Delete nxupsvc" >> $FILE
if [ -f $OUT ]; then
    rm -f $OUT
fi

echo "Delete nxupui" >> $FILE
if [ -f $IN ]; then
    rm -f $IN
fi

echo "Upgrade is done and successful" >> $FILE
echo "--------------------------------------------" >> $FILE
exit 0