#!/bin/sh

# Make sure only root can run our script
if [ "$(id -u)" -ne 0 ]; then
   echo "This uninstaller must be run as root."
   exit 1
fi

ps -p 1 | grep systemd >> /dev/null
if [ $? -eq 0 ]; then
	systemctl is-active --quiet NEService && systemctl stop NEService && systemctl disable NEService

	if [ -f "/etc/systemd/system/NEService.service" ]; then
		echo "Removed /etc/systemd/system/NEService.service"
		rm /etc/systemd/system/NEService.service
	fi
fi

ps -p 1 | grep init >> /dev/null
if [ $? -eq 0 ]; then
	update-rc.d neservice remove

	servicepid=$(pidof NEService)
	if ! [ -z ${servicepid} ]; then
		echo "Killed running NEService"
		kill ${servicepid}
	fi

	if [ -f "/etc/init.d/NEService" ]; then
		echo "Removed /etc/init.d/NEService"
		rm /etc/init.d/neservice
	fi
fi

nxpid=$(pidof NetExtender)
if ! [ -z ${nxpid} ]; then
	echo "Killed running NetExtender"
	kill ${nxpid}
fi

clipid=$(pidof nxcli)
if ! [ -z ${clipid} ]; then
	echo "Killed running nxcli"
	kill ${clipid}
fi

if [ -L /usr/local/bin/NEService ]; then
	echo "Unlink /usr/local/bin/NEService"
	unlink /usr/local/bin/NEService
fi

if [ -L "/usr/bin/wg" ]; then
	echo "Unlink /usr/bin/wg"
	unlink /usr/bin/wg
fi

if [ -L "/usr/bin/wg-quick" ]; then
	echo "Unlink /usr/bin/wg-quick"
	unlink /usr/bin/wg-quick
fi

if [ -L "/usr/bin/wireguard-go" ]; then
	echo "Unlink /usr/bin/wireguard-go"
	unlink /usr/bin/wireguard-go
fi

if [ -L "/usr/local/bin/NEService" ]; then
	echo "Unlink /usr/local/bin/NEService"
	unlink /usr/local/bin/NEService
fi

if [ -L "/usr/local/bin/nxcli" ]; then
	echo "Unlink /usr/local/bin/nxcli"
	unlink /usr/local/bin/nxcli
fi

if [ -f "/usr/share/applications/com.sonicwall.NetExtender.desktop" ]; then
	echo "Removed /usr/share/applications/com.sonicwall.NetExtender.desktop"
	rm -f /usr/share/applications/com.sonicwall.NetExtender.desktop
fi

if [ -d "/usr/local/netextender" ]; then
	echo "Removed /usr/local/netextender folder"
	rm -r /usr/local/netextender
fi

if [ -d "/var/log/NetExtender" ]; then
	echo "Removed /var/log/NetExtender folder"
	rm -r /var/log/NetExtender
fi

if [ "$1" != "-upgrade" ]; then
	if [ -d "/etc/SonicWall/NetExtender" ]; then
		echo "Removed /etc/SonicWall/NetExtender folder"
		rm -r /etc/SonicWall/NetExtender
	fi
	
	if [ -f "/tmp/upgrade.sh" ]; then
		echo "Removed /tmp/upgrade.sh"
		rm -f /tmp/upgrade.sh
	fi
fi

#if [ -d "/var/log/SonicWall/NetExtender" ]; then
#	echo "Removed /var/log/SonicWall/NetExtender folder"
#	rm -r /var/log/SonicWall/NetExtender
#fi

if [ -d "/home/${SUDO_USER}/.SonicWall/NetExtender" ]; then
	echo "Removed /home/${SUDO_USER}/.SonicWall/NetExtender"
	rm -r /home/${SUDO_USER}/.SonicWall/NetExtender
fi

if ! [ -L "/usr/sbin/netExtender" ]; then
	echo "Unlink /usr/sbin/netExtender"
	unlink /usr/sbin/netExtender
fi

echo "Uninstall SonicWall Netextender successfully"
exit 0
